/*
    This file is part of the saxparser for Java from the Metalinks tools project
    Copyright (C) 2007  A. Bram Neijt <bneijt@gmail.com>
 
    06 Mar 2007 René Kraneis <rene.kraneis@web.de>
    mostly whitespace (astyle --style=ansi)
    cleanup and modifications regarding hashmaps
 
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
*/

package phex.metalink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;



/** 
 * Metalink data container class
*/

public class DMetalink
{
    /**
     * The workhorse of the system
     */
    public class FileEntry
    {
        public HashMap<String, String> hashes;
        public ArrayList<UrlEntry> urls;
        public String filename;

        public FileEntry(String name)
        {
            filename = name;
            hashes = new HashMap<String, String> ();
            urls = new ArrayList<UrlEntry> ();
        }
    }

    public class UrlEntry
    {
        public String type;
        public String url;

        public UrlEntry ( String type, String url )
        {
            this.type = type; this.url = url;
        }
    }

    public ArrayList<FileEntry> files;

    public DMetalink()
    {
        files = new ArrayList<FileEntry> ();
    }

    /** 
     * Start a new file, with a given filename
     */
    public void newFile ( String filename )
    {
        files.add ( new FileEntry (filename) );
    }

    //Add a link to the last started file
    public void addURL ( String proto, String url )
    {
        //TODO allow for type, preference etc.
        FileEntry f = files.get (files.size() - 1);
        f.urls.add (new UrlEntry(proto, url));
    }

    public void addHash (String type, String value)
    {
        FileEntry f = files.get (files.size() - 1);
        f.hashes.put (type, value);
    }

    public String toString()
    {
        String s = new String();
        s += files.size() + " files known\n";

        for (FileEntry f : files)
        {
            s += "filename=" + f.filename + "\n";
            for(UrlEntry u : f.urls)
            {
                s += "  url= " + u.url + "\n";
            }

            for(Iterator<Map.Entry<String, String>> hi = f.hashes.entrySet().iterator(); hi.hasNext();)
            {
                Map.Entry hash = hi.next();
                s += "  hash(" + hash.getKey() + ")= " + hash.getValue() + "\n";
            }
        }
        return s;
    }
}
